% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IncomparabilityRelation.R
\name{IncomparabilityRelation}
\alias{IncomparabilityRelation}
\title{Computing the incomparability relation of a poset.}
\usage{
IncomparabilityRelation(poset)
}
\arguments{
\item{poset}{An object of S4 class POSet.
Argument \code{poset} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}
}
\value{
A two-column matrix \eqn{M} (element \eqn{M[i,2]} is incomparable with element \eqn{M[i,1]}).
}
\description{
Computes the incomparability relation of the input poset.
}
\examples{
elems <- c("a", "b", "c", "d")

dom <- matrix(c(
  "a", "b",
  "c", "b"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = elems, dom = dom)

M <- IncomparabilityRelation(pos)

}
