% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.R
\name{find_var_age}
\alias{find_var_age}
\title{Identify an Age Variable}
\usage{
find_var_age(nms)
}
\arguments{
\item{nms}{A character vector}
}
\value{
An element of \code{nms}, or \code{NULL}.
}
\description{
Find the element of \code{nms} that looks like an age variable.
If no elements look like an age variable, or if
two or more elements do,
then return \code{NULL}.
}
\examples{
find_var_age(c("Sex", "Year", "AgeGroup", NA)) ## one valid
find_var_age(c("Sex", "Year"))                 ## none valid
find_var_age(c("age", "age.years"))            ## two valid
}
\seealso{
\code{\link[=find_var_time]{find_var_time()}}, \code{\link[=find_var_sexgender]{find_var_sexgender()}}
}
