% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age.R
\name{age_labels}
\alias{age_labels}
\title{Create Age Labels}
\usage{
age_labels(type, min = 0, max = 100, open = NULL)
}
\arguments{
\item{type}{Type of age group labels:
\code{"single"}, \code{"five"}, or \code{"lt"}.}

\item{min}{Minimum age. Defaults to 0.}

\item{max}{Maximum age for closed age groups.
Defaults to 100.}

\item{open}{Whether the last age group is
"open", ie has no upper limit.}
}
\value{
A character vector.
}
\description{
Create labels for age groups. The labels depend
on the \code{type} argument:
\itemize{
\item \code{"single"}. One-year age groups, eg
\code{"0"} or \code{"55"}, and possibly
an open age group, eg \code{"90+"}.
\item \code{"five"}. Five-year age groups, eg
\code{"0-4"} or \code{"55-59"}, and possibly
an open age group, eg \code{"100+"}.
\item \code{"lt"}. Life table age groups, eg
\code{"0"}, \code{"1-4"}, \code{"5-9"},
\code{"55-59"}, or \code{"80+"}.
}
}
\details{
The first age group starts at the age
specified by \code{min}. If \code{open} is \code{TRUE},
then the final age group starts at the age
specified by \code{max}. Otherwise, the
final age group ends at the age specified
by \code{max}.

\code{open} defaults to \code{TRUE} when
\code{min} equals zero, and to \code{FALSE}
otherwise.
}
\examples{
age_labels(type = "single", min = 15, max = 40)
age_labels(type = "five")
age_labels(type = "lt", max = 80)
}
\seealso{
\code{\link[=reformat_age]{reformat_age()}}
}
