% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transfun-class.R
\name{transfun}
\alias{*.transfun}
\alias{is.transfun}
\alias{parameters.transfun}
\alias{parameters<-.transfun}
\alias{print.transfun}
\alias{transfun}
\title{transfun objects}
\usage{
is.transfun(x)

\method{print}{transfun}(x, ...)

\method{*}{transfun}(x, y)

\method{parameters}{transfun}(x)

\method{parameters}{transfun}(x) <- value
}
\arguments{
\item{x}{a transfun object to print or an object to test as a transfun object}

\item{y}{a transfun object to be multiplied with another with the same
pathway}

\item{value}{a named list of parameters matching those currently defined for \code{x}}

\item{\dots}{further arguments passed to or from other methods.}
}
\description{
utility functions for the \code{transfun} class. \code{transfun}
  objects are created by functions such as \code{\link{probability}}.
}
\details{
multiplication of transfun objects with the same pathway results in
  a compound transfun object (also of class \code{transfun}). When used in a
  stochastic model, the two stochastic transitions are evaluated one after
  another. When analysed deterministically, the expectation of the compound
  transition function is taken as the product of the expectations of the two
  basis transfuns.
}
\examples{
prob <- p(0.3)
is.transfun(prob)

prob
(compound <- prob * r(4.3))

# extract the transfun parameters
(param_prob <- parameters(prob))
(param_compound <- parameters(compound))

# update the parameters of these transfuns
param_prob$p <- 0.6
parameters(prob) <- param_prob
parameters(prob)

param_compound$r <- 15
parameters(compound) <- param_compound
parameters(compound)
}

