% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamic-class.R
\name{dynamic}
\alias{as.matrix.dynamic}
\alias{dynamic}
\alias{is.dynamic}
\alias{parameters.dynamic}
\alias{parameters<-.dynamic}
\alias{plot.dynamic}
\alias{print.dynamic}
\alias{states}
\title{dynamic objects}
\usage{
dynamic(...)

is.dynamic(x)

\method{plot}{dynamic}(x, ...)

states(x)

\method{print}{dynamic}(x, ...)

\method{as.matrix}{dynamic}(x, which = c("A", "P", "F", "R"), ...)

\method{parameters}{dynamic}(x)

\method{parameters}{dynamic}(x) <- value
}
\arguments{
\item{x}{a dynamic object to print, plot, convert to a transition matrix, or
an object to test as a dynamic object (for \code{is.dynamic}),}

\item{which}{which type of matrix to build: the overall population growth
matrix (\code{'A'}), the probabilistic progression matrix (\code{'P'}), the
fecundity matrix (\code{'F'}) or the intrinsic reproduction matrix
(\code{'R'})}

\item{value}{a nested named list of parameters within each transition
matching those currently defined for \code{x}}

\item{\dots}{for \code{dynamic()}: one or more \code{transition} (or other
\code{dynamic}) objects making up the dynamic. For \code{plot()} and
\code{print()}: further arguments passed to or from other methods}
}
\description{
creates a \code{dynamic} object, comprising multiple
  \code{transition} objects to define a dynamical system. \code{dynamic}
  objects are the core of \code{pop}, since they can be created and updated
  using various methods (MPMs, IPMs etc.), combined (by addition of two
  \code{dynamic} objects to make another) and and analysed in various ways
  (deterministically to obtain demographic parameters, simulated to evaluate
  population viability etc.)
}
\examples{
# define transitions for a simple three-stage system (with implicit
# mortality):
stasis_egg <- tr(egg ~ egg, p(0.4))
stasis_larva <- tr(larva ~ larva, p(0.3))
stasis_adult <- tr(adult ~ adult, p(0.8))
hatching <- tr(larva ~ egg, p(0.5))
fecundity <- tr(egg ~ adult, r(3))
pupation <- tr(adult ~ larva, p(0.2))

# combine these into separate dynamics
stasis <- dynamic(stasis_egg,
                  stasis_larva,
                  stasis_adult)
growth <- dynamic(hatching,
                  pupation)
reproduction <- dynamic(fecundity)

# combine these into one dynamic (the same as listing all the transitions
# separately)
all <- dynamic(stasis, growth, reproduction)

# plot these
plot(stasis)
plot(growth)
plot(all)

# get component states
states(all)

# print method
print(all)

# convert to a transition matrix
as.matrix(all)
# extract the parameters
(param_stasis <- parameters(stasis))
(param_all <- parameters(all))

# update the parameters of these transfuns
param_stasis$stasis_egg$p <- 0.6
parameters(stasis) <- param_stasis
parameters(stasis)

param_all$fecundity$r <- 15
parameters(all) <- param_all
parameters(all)
}

