% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPyramid.R
\name{plotPyramid}
\alias{plotPyramid}
\title{Population pyramid graph}
\usage{
plotPyramid(
  df,
  age,
  sex,
  pop,
  labx = pop,
  laby = age,
  twocolors = c("#41ae76", "#ef6548"),
  rotation = 90,
  n.breaks = 20,
  value.labels = TRUE,
  position.value.labels = "in",
  size.value.labels = 3
)
}
\arguments{
\item{df}{Name of dataframe}

\item{age}{Age or age group. Write the parameter in quotation marks.}

\item{sex}{Sex or other categorical grouping variable. Write the parameter in quotation marks.}

\item{pop}{Population (in numerical value). Write the parameter in quotation marks.}

\item{labx}{X-axis label}

\item{laby}{Y-axis label}

\item{twocolors}{Two colors for the pyramid}

\item{rotation}{X-axis label rotation}

\item{n.breaks}{Number of breaks}

\item{value.labels}{Show values in the bars. Use TRUE to include the labels in the bars. Use FALSE to not include them.}

\item{position.value.labels}{Position of the values on the bars. Use "in" to display the labels inside the bars. Use "out" to display them outside the bars.}

\item{size.value.labels}{Font size of the values in the bars}
}
\value{
A population pyramid graph
}
\description{
Create a population pyramid graph
}
\examples{
df <- popPyramid::popPER
df <- dplyr::filter(df, Year==2021)
plotPyramid(df=df, age="gAge", sex="Sex", pop="Population", value.labels=FALSE)

}
