% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_pool.R
\name{pool2sync}
\alias{pool2sync}
\title{Create 'synchronized' file from Pool-seq data}
\usage{
pool2sync(reference, alternative, file, pos = NULL)
}
\arguments{
\item{reference}{is a list where each entry corresponds to a different locus.
Each list entry is a vector with the number of reads with the reference
allele. Each entry of the vector corresponds to a different SNP. This list
can have a single entry if the data is comprised of a single locus.}

\item{alternative}{is a list where each entry corresponds to a different
locus. Each list entry is a vector with the number of reads with the
alternative allele. Each entry of the vector corresponds to a different
SNP. This list can have a single entry if the data is comprised of a single
locus.}

\item{file}{is a character string naming the file to write to.}

\item{pos}{is an optional input (default is NULL). If the actual position of
the SNPs are known, they can be used as input here. When working with a
single locus, this should be a numeric vector with each entry corresponding
to the position of each SNP. If the data has multiple loci, this should be
a list where each entry is a numeric vector with the position of the SNPs
for a different locus.}
}
\value{
a file in the current working directory containing Pool-seq data in
the 'synchronized' format.
}
\description{
Creates and saves a file with the information from Pool-seq data coded in the
'synchronized' format.
}
\details{
It starts by converting the number of reads with the \code{reference} allele
and the \code{alternative} allele to a
A-count:T-count:C-count:G-count:N-count:deletion-count string. Here, we
assume that the reference allele is always A and the alternative is always T.

Then, this A-count:T-count:C-count:G-count:N-count:deletion-count string is
combined with other necessary information such as the chromosome of each SNP,
the position of the SNP and the reference character. This step creates a data
frame where each row corresponds to a different SNP.

A \code{file} is then created and saved in the current working directory,
with the Pool-seq data coded in the 'synchronized' file format.
}
\examples{
# simulate Pool-seq data for 100 individuals sampled at a single locus
genotypes <- run_scrm(nDip = 100, nloci = 1, theta = 5)
# simulate Pool-seq data assuming a coverage of 100x and two pools of 50 individuals each
pool <- simPoolseq(genotypes = genotypes, pools = c(50, 50), pError = 100, sError = 0.001,
mCov = 100, vCov = 250, min.minor = 0)
# create a 'synchronized' file of the simulated data - this will create a txt file
# pool2sync(reference = pool$reference, alternative = pool$alternative, file = "mysync.txt")

# simulate Pool-seq data for 10 individuals sampled at 5 loci
genotypes <- run_scrm(nDip = 10, nloci = 5, theta = 5)
# simulate Pool-seq data assuming a coverage of 100x and a single pool of 10 individuals
pool <- simPoolseq(genotypes = genotypes, pools = 10, pError = 100, sError = 0.001,
mCov = 100, vCov = 250, min.minor = 0)

# create a 'synchronized' file of the simulated data - this will create a txt file
# pool2sync(reference = pool$reference, alternative = pool$alternative, file = "mysync.txt")

}
