% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_pool.R
\name{filterMinor}
\alias{filterMinor}
\title{Filter sites according to a minor-allele reads threshold}
\usage{
filterMinor(reference, alternative, coverage, min.minor)
}
\arguments{
\item{reference}{a matrix with the number of reads with the reference allele.
Each row should be a different population and each column a different site.}

\item{alternative}{a matrix with the number of reads with the alternative
allele. Each row should be a different population and each column a
different site.}

\item{coverage}{is a matrix of total coverage. Each row of the matrix should
be a different population and each column a different site. Thus, each
entry of the matrix contains the total number of observed reads for that
population at a given site.}

\item{min.minor}{is an integer representing the minimum allowed number of
minor-allele reads. Sites that, across all populations, have less
minor-allele reads than this threshold will be removed from the data.}
}
\value{
a list with three named entries:

\item{reference}{a list with one entry per locus. Each entry is a matrix with
the number of reference allele reads. Each column represents a different site.}

\item{alternative}{a list with one entry per locus. Each entry is a matrix with
the number of alternative allele reads. Each column represents a different site.}

\item{total}{a list with one entry per locus. Each entry is a matrix with
the total depth of coverage. Each column represents a different site.}
}
\description{
Removes sites from matrices with counts of reads. If a site has less
minor-allele reads than \code{min.minor} across all populations, that site is
removed from the data.
}
\keyword{internal}
