% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dinit_spec.R
\name{dinit_spec}
\alias{dinit_spec}
\title{dinit specification}
\description{
Specification of the initial-state distribution density evaluator, dinit.
}
\details{
To fully specify the unobserved Markov state process, one must give its distribution at the zero-time (\code{t0}).
One specifies how to evaluate the log probability density function for this distribution using the \code{dinit} argument.
As usual, this can be provided either as a C snippet or as an \R function.
In the former case, bear in mind that:
\enumerate{
  \item The goal of a this snippet is computation of a log likelihood, to be put into a variable named \code{loglik}.
  \item In addition to the state variables, parameters, and covariates (if any), the variable \code{t}, containing the zero-time, will be defined in the context in which the snippet is executed.
}
\link[=Csnippet]{General rules for writing C snippets can be found here}.

If an \R function is to be used, pass
\preformatted{
   dinit = f
}
to \code{pomp}, where \code{f} is a function with arguments that can include the time \code{t}, any or all of the model state variables, parameters, and covariates.
As usual, \code{f} may take additional arguments, provided these are passed along with it in the call to \code{pomp}.
\code{f} must return a single numeric value, the log likelihood.
}
\section{Note for Windows users}{


Some Windows users report problems when using C snippets in parallel computations.
These appear to arise when the temporary files created during the C snippet compilation process are not handled properly by the operating system.
To circumvent this problem, use the \code{\link[=pomp]{cdir}} and \code{\link[=pomp]{cfile}} options to cause the C snippets to be written to a file of your choice, thus avoiding the use of temporary files altogether.
}

\seealso{
\code{\link{dinit}}

More on implementing POMP models:
\code{\link{Csnippet}},
\code{\link{accumvars}},
\code{\link{basic_components}},
\code{\link{betabinomial}},
\code{\link{covariates}},
\code{\link{dmeasure_spec}},
\code{\link{dprocess_spec}},
\code{\link{emeasure_spec}},
\code{\link{eulermultinom}},
\code{\link{parameter_trans}()},
\code{\link{pomp-package}},
\code{\link{pomp_constructor}},
\code{\link{prior_spec}},
\code{\link{rinit_spec}},
\code{\link{rmeasure_spec}},
\code{\link{rprocess_spec}},
\code{\link{skeleton_spec}},
\code{\link{transformations}},
\code{\link{userdata}},
\code{\link{vmeasure_spec}}
}
\concept{implementation information}
