% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RF_Model.R
\name{RF_Model}
\alias{RF_Model}
\title{Random Forest}
\usage{
RF_Model(Data, xvar, yvar)
}
\arguments{
\item{Data}{The name of the Dataset.}

\item{xvar}{X variables.}

\item{yvar}{Y variable.}
}
\value{
The output from  \code{\link{RF_Model}}.
}
\description{
Random Forest
}
\details{
Rather than considering the random sample of \eqn{m}{m} predictors
from the total of \eqn{p}{p} predictors in each split,
random forest does not consider a majority of the \eqn{p}{p} predictors, and considers in each split a
fresh sample of  \eqn{m_{try}}{m_{try}} which we usually set  to \eqn{m_{try} \approx \sqrt{p}}
Random forests which de-correlate the trees by considering  \eqn{m_{try} \approx \sqrt{p}}
show an improvement over bagged trees  \eqn{m = p}{m = p}.
}
\examples{
\donttest{
sample_data <- sample_data[c(1:750),]
yvar <- c("Loan.Type")
xvar <- c("sex", "married", "age", "havejob", "educ", "political.afl",
"rural", "region", "fin.intermdiaries", "fin.knowldge", "income")
BchMk.RF <- RF_Model(sample_data, c(xvar, "networth"), yvar )
BchMk.RF
 }
}
