% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polypoly-package.R
\name{poly_melt}
\alias{poly_melt}
\title{Melt a polynomial matrix}
\usage{
poly_melt(x)
}
\arguments{
\item{x}{a matrix created by \code{\link[stats:poly]{stats::poly()}}}
}
\value{
a \code{\link[tibble:tibble]{tibble::tibble()}} with three columns: \code{observation} (row number of
the matrix), polynomial \code{degree}, and \code{value}.
}
\description{
Melt a polynomial matrix
}
\details{
The \code{degree} values are returned as a character vector because they
should be treated categorically (as when plotting). Moreover, matrices
made with multiple vectors (e.g., \code{poly(rnorm(10), rnorm(10), degree = 2)})
have names that are not numerically meaningful (e.g., \code{1.0}, \code{2.0}, \code{0.1},
\code{1.1}, \code{0.2}),
}
\examples{
m <- poly(rnorm(10), degree = 3)
poly_melt(m)
}
