% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orci.r
\name{orci}
\alias{orci}
\title{Translate logistic regression coefficients into odds ratios}
\usage{
orci(model, digits = 3)
}
\arguments{
\item{model}{An estimated logistic regression model}

\item{digits}{Number of digits after decimal to display}
}
\value{
Returns odds rations and confidence intervals in columns (a matrix class object)
}
\description{
Generates odds-ratios based on logistic regression model coefficients
}
\examples{
   library(poliscidata)
   obama_state_model <- glm(obama_win12 ~ secularism + gunlaw_rank, data=states, family=binomial)
   summary(obama_state_model)
   orci(obama_state_model)
   
   obama_vote_model <- svyglm(obama_vote ~ ft_dem, design=nesD, family="quasibinomial")
   summary(obama_vote_model)
   orci(obama_vote_model)
}
