% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/urgency.R
\name{sim_urgency}
\alias{sim_urgency}
\title{Simulating urgency in priorities}
\usage{
sim_urgency(urgency, commitment, intensity, timing, frequency, pronoun = "We")
}
\arguments{
\item{urgency}{Desired urgency score, optional.}

\item{commitment}{Desired commitment score, optional.}

\item{intensity}{Desired intensity score, optional.}

\item{timing}{Desired timing score, optional.}

\item{frequency}{Desired frequency score, optional.}

\item{pronoun}{How would you like the simulated priorities to start?
By default, priorities start with the pronoun "We".}
}
\value{
A sentence that matches the urgency or urgency dimension scores.
}
\description{
Simulating urgency in priorities
}
\details{
Users can declare a score for one or more of the
urgency dimensions or an urgency score.
This means, if users may not declare an urgency score and the
score for one or more dimensions at once.
In those cases, the urgency score is favored.
}
\examples{
\donttest{
sim_urgency()
sim_urgency(urgency = 0.5)
sim_urgency(urgency = 2.5)
sim_urgency(urgency = -2.5)
sim_urgency(commitment = 0.6)
sim_urgency(commitment = 0.6, intensity = 1.4)
sim_urgency(commitment = 0.6, intensity = 1.4, timing = 1.4)
sim_urgency(commitment = 0.6, intensity = 1.2, timing = 1.4, frequency = 1.8)
}
}
