% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{genPluscode}
\alias{genPluscode}
\title{Generate Plus Code}
\usage{
genPluscode(geom, codeLength = 10)
}
\arguments{
\item{geom}{An object of class sfc or (sf, data.frame).}

\item{codeLength}{An optional number between 4 and 15 exluding 5, 7, 9; default is 10.}
}
\value{
Depending on input it returns a character or an object of class (sf, data.frame).
}
\description{
Main function of the package. It generates a plus code giving as input a sfc object or a sf data.frame and a code length.
Code length is related to the precision as dimension of the area.
The precision of a plus code is indicated by the number of digits after the "+" sign. For example:

10 (2 digits after "+") -> area of 13.7 by 13.7 meters.

11 (3 digits after "+") -> area of 2.7 by 3.5 meters.

12 (4 digits after "+") -> area of 0.5 by 0.8 meters.
}
\examples{
library(sf)
point <- st_sfc(st_point(c(0, 0)))
genPluscode(point,10)
###
coordinates_df <- data.frame(lon = c(-6.56718, -6), lat = c(52.50145, 52))
geom_df <- st_as_sf(coordinates_df, coords = c("lon", "lat"), crs = 4326)
genPluscode(geom_df)
}
