% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed.R
\name{readIID}
\alias{readIID}
\title{read individual ID}
\usage{
readIID(fam, opt = NULL)
}
\arguments{
\item{fam}{prefix or name of a PLINK file, or data fram from a FAM file.}

\item{opt}{option (def=1: the 2nd column in FAM file).}
}
\value{
a vector of individual ID
}
\description{
Generate individual ID automatically, or based on a \emph{fam} file.
}
\details{
The option (\code{opt}) can be:
\itemize{
\item 1 = the \emph{iid} column in FAM (default),
\item 2 = formated as \emph{fid}.\emph{iid},
\item 0 = nothing
\item -1 = numbering of individuals, decimal
\item -2 = numbering of individuals, zero-padded fix-length decimal
\item -3 = numbering of individuals, zero-padded fix-length hexedemical
or, a vector of IDs to use.
}
}
\examples{
pfx <- file.path(system.file("extdata", package="plinkFile"), "m20")
readIID(pfx,  1) # opt= 1: IID
readIID(pfx,  2) # opt= 2: FID.IID
readIID(pfx, -1) # opt=-1: number sequence
readIID(pfx, -2) # opt=-2: number sequence, fixed length, decimal
readIID(pfx, -3) # opt=-3: number sequence, fixed length, hexidemical

}
