\name{pl.envir}
\title{Environment Containing Information for Generating Pl Graphics}
\alias{pl.envir}
\docType{data}
\description{The \code{\link{environment}} \code{pl.envir} contains options and
  information generated by the user or the high level \code{pl*()} functions
  to guide many aspects of pl graphical displays.
}
\usage{ pl.envir }
%%\format{
%%  The format is:
%%<environment: 0x55c36f0b6ba0>
%%}
\details{
  The \code{\link{environment}} contains the following objects:
  \describe{
   \item{\code{usr.ploptions}: }{The ploptions that are the current
    user choice. It is initiated with the package's
    choices in \code{\link{default.ploptions}} and
    modified whenever \code{ploptions} are set
    (and \code{assign} is \code{TRUE}),
    see \code{\link{ploptions}}.
   }
   \item{\code{ploptions}: }{The last (or current) list used
    (and often modified) by a high level pl function.
   }
   \item{\code{plfeatures, marpar}: }{Additional features used by pl functions}
   \item{\code{pldata}: }{The last (or current) data set used by pl functions}
   \item{\code{pl.scaleFunctions}: }{scale functions known to \pkg{plgraphics},
    useful for scales to be used for showing axes.}
  }
}
\examples{
pl.envir$usr.ploptions$margin.line   ## same as ...
ploptions("margin.line")
# The objects inside pl.envir:
ls(pl.envir) 

plyx(1:4)
ploptions(margin.line=c(3,1))
ploptions("margin.line")
pl.envir$usr.ploptions$margin.line
pl.envir$ploptions$margin.line  ## the choice for
  ## the last called high level pl function
str( pl.envir$plfeatures )
% MM: does not exist:
% pl.envir$marpar  ## used internally by that function
}
\keyword{internal}
