% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plastic_prev_plots.R
\name{prevalence_plot}
\alias{prevalence_plot}
\title{Plastic prevalence probability plot}
\usage{
prevalence_plot(prev_prob_mat, sample_sizes, lower_ci, upper_ci,
  xlab = "Sample size", ylab = "Plastic prevalence probability",
  colobs = "grey", colci = "#64B5F6")
}
\arguments{
\item{prev_prob_mat}{numeric matrix, containing plastic prevalence probability
with dimensions (samples_size, bootstrap_replicates).}

\item{sample_sizes}{numeric vector, containing sequence of sample size used to
estimate the confidence intervals \code{plastic.ci}.}

\item{lower_ci}{numeric vector, containing values for lower confidence interval
and with the same length as \code{sample_sizes}.}

\item{upper_ci}{numeric vector, containing values for upper confidence interval
and with the same length as \code{sample_sizes}.}

\item{xlab}{string, label of x axis.}

\item{ylab}{string, label of y axis.}

\item{colobs}{color of observations.}

\item{colci}{color of confidence intervals.}
}
\description{
Plot to show the plastic prevalence probability in seabird's nests as a function of
different sample sizes and their corresponding confidence intervals.
}
\examples{
binomtest <- plastic.ci(rbinom(1000,1,0.5), 30, 100)
prevalence_plot(binomtest$prevprob,
                binomtest$cidtf$N,
                binomtest$cidtf$lower_ci,
                binomtest$cidtf$upper_ci)
}
\seealso{
\code{\link{plastic.ci}}, \code{\link{plastic.prev.prob}}
}
