% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareDoses.R
\name{trimDoses}
\alias{trimDoses}
\title{Trim Dose Data Set}
\usage{
trimDoses(
  doseData,
  drugLevelData,
  drugLevelID = "id",
  drugLevelTimeVar = "date.time",
  drugLevelVar = "fent.level",
  infusionDoseTimeVar = NULL,
  infusionDoseVar = NULL,
  bolusDoseTimeVar = NULL,
  bolusDoseVar = NULL,
  otherDoseTimeVar = NULL,
  otherDoseVar = NULL,
  lookForward = 7,
  last = NA
)
}
\arguments{
\item{doseData}{data.frame; data set with dose information}

\item{drugLevelData}{data.frame; data set with drug level data}

\item{drugLevelID}{character string; name of ID variable, defaults to id}

\item{drugLevelTimeVar}{character string; name of date-time variable,
defaults to date.time}

\item{drugLevelVar}{character string; name of drug level variable, defaults
to fent.level}

\item{infusionDoseTimeVar}{character string; name of infusion dose time
variable}

\item{infusionDoseVar}{character string; name of infusion dose variable}

\item{bolusDoseTimeVar}{character string; name of bolus dose time variable}

\item{bolusDoseVar}{character string; name of bolus dose variable}

\item{otherDoseTimeVar}{character string; name of additional dose time
variable}

\item{otherDoseVar}{character string; name of additional dose variable}

\item{lookForward}{integer; initializes the time frame window with the number
of days prior to the first drug level data; defaults to 7}

\item{last}{integer; sets the end of the time frame window to be "last" days
after the first dose date, rather than the date of the last drug level data}
}
\value{
data.frame, containing trimmed dose data
}
\description{
Remove invalid doses by creating a time frame window constructed from drug
level data.
}
\details{
The time frame window is generally seven days before drug level data up
through the last drug level data record.  The window can be adjusted by
setting the lookForward and last arguments.
}
\author{
Cole Beck
}
