% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-dea.R
\name{summary_tbl_dea}
\alias{summary_tbl_dea}
\title{Create a summary table for DEA}
\usage{
summary_tbl_dea(x)
}
\arguments{
\item{x}{A numeric vector of efficiency scores or an object of class \code{pioneer_dea}}
}
\value{
A \code{\link[=data.frame]{data.frame()}} with summary statistics
}
\description{
Create a binned summary table for efficiency scores from a DEA model.
}
\details{
The function will return a summary table for efficiency scores from a DEA model.
Efficiency scores will be placed in 11 bins, where DMUs with an efficiency score
equal to 1 are placed in a separate bin. For output oriented models with range
[1, Inf], bins are created with \code{1/bin}. Bin widths will be equal to models
with range [0, 1].
}
\examples{
# Load example data
fare89 <- deaR::Electric_plants
# Estimate efficiency
mod <- compute_dea(
  data = fare89,
  input = c("Labor", "Fuel", "Capital"),
  output = "Output",
  rts = "vrs"
)
# Get a summary table of efficiency scores
summary_tbl_dea(mod)
# You can also create the table from a numeric vector of efficiency scores
res <- as.data.frame(mod)
summary_tbl_dea(res$efficiency)
}
