#' Human rights abuses in the Pinochet regime, 1973-1990
#'
#' A dataset containing information about victims of the Pinochet regime
#' in Chile (1973-1990). The data comes from the National Truth and Reconciliation
#' Commission Report (1991, ISBN:9780268016463). We included georeferenced information about all incidents
#' where the information could be retrieved. More information about the coding process
#' is available at http://github.com/danilofreire/pinochet.
#'
#' @docType data
#'
#' @usage data(pinochet)
#'
#' @format A data frame with 2398 rows and 59 variables:
#' \describe{
#'   \item{additional_comments}{any further information on the victim}
#'   \item{age}{victim's age}
#'   \item{end_date_daily}{calendar day when the human rights abuse ended}
#'   \item{end_date_monthly}{calendar month when human rights abuse ended}
#'   \item{exact_coordinates_1}{exactitude of coordinates for place_1, 1 = exact}
#'   \item{exact_coordinates_2}{exactitude of coordinates for place_2, 1 = exact}
#'   \item{exact_coordinates_3}{exactitude of coordinates for place_3, 1 = exact}
#'   \item{exact_coordinates_4}{exactitude of coordinates for place_4, 1 = exact}
#'   \item{exact_coordinates_5}{exactitude of coordinates for place_5, 1 = exact}
#'   \item{exact_coordinates_6}{exactitude of coordinates for place_6, 1 = exact}
#'   \item{first_name}{victim's first name}
#'   \item{group_id}{unique id for groups of individuals attacked together}
#'   \item{individual_id}{unique individual id}
#'   \item{interrogation}{individual was interrogated, 1 = yes}
#'   \item{last_name}{victim's last name}
#'   \item{latitude_1}{latitudinal coordinates pertaining to the string place_1 variable}
#'   \item{latitude_2}{latitudinal coordinates pertaining to the string place_2 variable}
#'   \item{latitude_3}{latitudinal coordinates pertaining to the string place_3 variable}
#'   \item{latitude_4}{latitudinal coordinates pertaining to the string place_4 variable}
#'   \item{latitude_5}{latitudinal coordinates pertaining to the string place_5 variable}
#'   \item{latitude_6}{latitudinal coordinates pertaining to the string place_6 variable}
#'   \item{location_1}{where the individual was seen or found}
#'   \item{location_2}{where the individual was seen or found}
#'   \item{location_3}{where the individual was seen or found}
#'   \item{location_4}{where the individual was seen or found}
#'   \item{location_5}{where the individual was seen or found}
#'   \item{location_6}{where the individual was seen or found}
#'   \item{longitude_1}{longitudinal coordinates pertaining to the string place_1 variable}
#'   \item{longitude_2}{longitudinal coordinates pertaining to the string place_2 variable}
#'   \item{longitude_3}{longitudinal coordinates pertaining to the string place_3 variable}
#'   \item{longitude_4}{longitudinal coordinates pertaining to the string place_4 variable}
#'   \item{longitude_5}{longitudinal coordinates pertaining to the string place_5 variable}
#'   \item{longitude_6}{longitudinal coordinates pertaining to the string place_6 variable}
#'   \item{male}{victim is male, 1 = yes}
#'   \item{method}{method of violence, 25 categories}
#'   \item{minor}{victim is minor, 1 = yes}
#'   \item{mistreatment}{individual was mistreated, 1 = yes}
#'   \item{nationality}{individual's nationality}
#'   \item{number_previous_arrests}{number of individual's previous arrests}
#'   \item{occupation}{victim's occupation}
#'   \item{occupation_detail}{details about victim's occupation, when available}
#'   \item{page}{report page where we retrieved information about the victim}
#'   \item{perpetrator_affiliation}{perpetrator's political affiliation}
#'   \item{perpetrator_affiliation_detail}{details about perpetrator's political affiliation}
#'   \item{place_1}{place where the individual was spotted/reported to be seen (in chronological order, from 1 to 6 places)}
#'   \item{place_2}{place where the individual was spotted/reported to be seen (in chronological order, from 1 to 6 places)}
#'   \item{place_3}{place where the individual was spotted/reported to be seen (in chronological order, from 1 to 6 places)}
#'   \item{place_4}{place where the individual was spotted/reported to be seen (in chronological order, from 1 to 6 places)}
#'   \item{place_5}{place where the individual was spotted/reported to be seen (in chronological order, from 1 to 6 places)}
#'   \item{place_6}{place where the individual was spotted/reported to be seen (in chronological order, from 1 to 6 places)}
#'   \item{press}{individual disappearance or death appeared in the press}
#'   \item{start_date_daily}{date when the victim suffered abuse}
#'   \item{start_date_monthly}{calendar month when victim suffered abuse}
#'   \item{victim_affiliation}{individual's political affiliation}
#'   \item{victim_affiliation_detail}{details about the individual's political affiliation, when available}
#'   \item{violence}{type of violence, 5 categories: killed, suicide, disappearance, disappearance information of death, unresolved}
#'   \item{targeted}{individual was targeted, 1 = yes}
#'   \item{torture}{individual was tortured, 1 = yes}
#'   \item{war_tribunal}{individual was subject to a war tribunal}
#' }
#'
#' @source Report of the Chilean National Commission on Truth and Reconciliation, volumes 1 and 2.
#'
#' @keywords datasets
#'
"pinochet"
