% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capture_logs.R
\name{capture_logs}
\alias{capture_logs}
\title{Capture ISP network logs}
\usage{
capture_logs(destinations = 9, pings = 50, log_path = NULL,
  sleep = NULL)
}
\arguments{
\item{destinations}{Retrieve the first n addresses in your ISP destinations}

\item{pings}{Number of times to ping server}

\item{log_path}{Optional: The path and filename to save the result set}

\item{sleep}{Optional: Seconds to sleep for throughout iterations}
}
\value{
csv file with captured network log information
}
\description{
Repeat capturing network logs with parameters you specify from
\code{\link{ping_capture}} and \code{\link{get_destinations}}. This will output a
csv file with your ping results displaying packet loss and average
ping across the defined periods.
}
\note{
If the log_path parameter is not provided, it will default to saving
a csv file in the current working directory called network_logs.csv prefixed
with the current timestamp in the format '%Y%m%d%H%M%S_network_logs.csv'
}
\examples{
\dontrun{
capture_logs(destinations = 3, pings = 10, log_path = log, sleep = 20)
}
}
