% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translink_expected_links_true_mtsl.R
\name{translink_expected_links_true_mtsl}
\alias{translink_expected_links_true_mtsl}
\title{Calculate expected number of true transmission pairs assuming multiple-transmission and single-linkage}
\usage{
translink_expected_links_true_mtsl(sensitivity, rho, M, R)
}
\arguments{
\item{sensitivity}{scalar or vector giving the sensitivity of the linkage criteria}

\item{rho}{scalar or vector giving the proportion of the final outbreak size that is sampled}

\item{M}{scalar or vector giving the number of cases sampled}

\item{R}{scalar or vector giving the effective reproductive number of the pathogen}
}
\value{
scalar or vector giving the expected number of true transmission pairs in the sample
}
\description{
This function calculates the expected number true transmission pairs in a sample of size \code{M}.
The multiple-transmission and single-linkage method assumes the following:
\enumerate{
\item Each case \eqn{i} is, on average, the infector of \code{R} cases in the population (\eqn{N})
\item Each case \eqn{i} is allowed to be linked by the linkage criteria to only one other case \eqn{j} in the sampled population (\eqn{M}).
}
}
\examples{
translink_expected_links_true_mtsl(sensitivity=0.95, rho=0.2, M=200, R=1)

}
\seealso{
Other transmission linkage functions: 
\code{\link{translink_expected_links_obs_mtml}()},
\code{\link{translink_expected_links_obs_mtsl}()},
\code{\link{translink_expected_links_obs_stsl}()},
\code{\link{translink_expected_links_obs}()},
\code{\link{translink_expected_links_true_mtml}()},
\code{\link{translink_expected_links_true_stsl}()},
\code{\link{translink_expected_links_true}()},
\code{\link{translink_fdr}()},
\code{\link{translink_prob_transmit_mtml}()},
\code{\link{translink_prob_transmit_mtsl}()},
\code{\link{translink_prob_transmit_stsl}()},
\code{\link{translink_prob_transmit}()},
\code{\link{translink_samplesize}()},
\code{\link{translink_tdr}()}
}
\author{
John Giles, Shirlee Wohl and Justin Lessler
}
\concept{transmission linkage functions}
