% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gendist_sensspec_cutoff.R
\name{gendist_sensspec_cutoff}
\alias{gendist_sensspec_cutoff}
\title{Calculate sensitivity and specificity of a genetic distance cutoff}
\usage{
gendist_sensspec_cutoff(
  cutoff,
  mut_rate,
  mean_gens_pdf,
  max_link_gens = 1,
  max_gens = NULL,
  max_dist = NULL
)
}
\arguments{
\item{cutoff}{the maximum genetic distance at which to consider cases linked}

\item{mut_rate}{mean number of mutations per generation, assumed to be Poisson distributed}

\item{mean_gens_pdf}{the density distribution of the mean number of generations between cases;
the index of this vector is assumed to be the discrete distance between cases}

\item{max_link_gens}{the maximum generations of separation for linked pairs}

\item{max_gens}{the maximum number of generations to consider, if \code{NULL} (default) value set to the highest
number of generations in mean_gens_pdf with a non-zero probability}

\item{max_dist}{the maximum distance to calculate, if \code{NULL} (default) value set to max_gens * 99.9th percentile
of mut_rate Poisson distribution}
}
\value{
a data frame with the sensitivity and specificity for a particular genetic distance cutoff
}
\description{
Function to calculate the sensitivity and specificity of a genetic distance cutoff
given an underlying mutation rate and mean number of generations between cases
}
\examples{
# calculate the sensitivity and specificity for a specific genetic distance threshold of 2 mutations
gendist_sensspec_cutoff(cutoff=2,
                        mut_rate=1,
                        mean_gens_pdf=c(0.02,0.08,0.15,0.75),
                        max_link_gens=1)

# calculate the sensitivity and specificity for a a range of genetic distance thresholds
gendist_sensspec_cutoff(cutoff=1:10,
                        mut_rate=1,
                        mean_gens_pdf=c(0.02,0.08,0.15,0.75),
                        max_link_gens=1)

}
\seealso{
Other genetic distance functions: 
\code{\link{gendist_distribution}()},
\code{\link{gendist_roc_format}()}
}
\author{
Shirlee Wohl and Justin Lessler
}
\concept{genetic distance functions}
