% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.metadata.r
\name{getWhereMeasured}
\alias{getWhereMeasured}
\alias{where_measured}
\alias{getWhereMeasured.default}
\alias{getWhereMeasured.generic_spct}
\alias{getWhereMeasured.summary_generic_spct}
\alias{getWhereMeasured.generic_mspct}
\alias{getWhereMeasured.data.frame}
\title{Get the "where.measured" attribute}
\usage{
getWhereMeasured(x, ...)

where_measured(x, ...)

\method{getWhereMeasured}{default}(x, ...)

\method{getWhereMeasured}{generic_spct}(
  x,
  ...,
  idx = getIdFactor(x),
  simplify = TRUE,
  .bind.geocodes = TRUE
)

\method{getWhereMeasured}{summary_generic_spct}(
  x,
  ...,
  idx = getIdFactor(x),
  simplify = TRUE,
  .bind.geocodes = TRUE
)

\method{getWhereMeasured}{generic_mspct}(
  x,
  ...,
  idx = "spct.idx",
  .bind.geocodes = TRUE,
  simplify = FALSE
)

\method{getWhereMeasured}{data.frame}(x, ...)
}
\arguments{
\item{x}{a generic_spct object}

\item{...}{Allows use of additional arguments in methods for other classes.}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}

\item{simplify}{logical If all members share the same attribute value return
one copy instead of a data.frame.}

\item{.bind.geocodes}{logical In the case of collections of spectra if
\code{.bind.geocodes = TRUE}, the default, the returned value is a single
geocode with one row for each member spectrum. Otherwise the individual
geocode data frames are returned in a list column within a tibble.}
}
\value{
a data.frame with a single row and at least columns "lon" and "lat",
   unless expand is set to \code{FALSE}.
}
\description{
Method to read the "where.measured" attribute of
generic_spct, generic_mspct, summary_generic_spct, data.frame or a
derived-class object.
}
\section{Methods (by class)}{
\itemize{
\item \code{getWhereMeasured(default)}: default

\item \code{getWhereMeasured(generic_spct)}: generic_spct

\item \code{getWhereMeasured(summary_generic_spct)}: summary_generic_spct

\item \code{getWhereMeasured(generic_mspct)}: generic_mspct

\item \code{getWhereMeasured(data.frame)}: data.frame

}}
\note{
If x is not a \code{generic_spct} or an object of a derived class
  \code{NA} is returned.
}
\examples{
getWhereMeasured(sun.spct)
getWhereMeasured(sun_evening.spct)
getWhereMeasured(sun_evening.spct, simplify = TRUE)
getWhereMeasured(sun_evening.mspct)
getWhereMeasured(sun_evening.mspct, .bind.geocodes = FALSE)
getWhereMeasured(sun_evening.mspct, simplify = TRUE)
getWhereMeasured(sun_evening.mspct, simplify = FALSE)

getWhereMeasured(summary(sun.spct))
getWhereMeasured(summary(sun_evening.spct))
getWhereMeasured(summary(sun_evening.mspct, expand = "each")[[1]])

getWhereMeasured(polyester.spct)

}
\seealso{
Other measurement metadata functions: 
\code{\link{add_attr2tb}()},
\code{\link{getFilterProperties}()},
\code{\link{getHowMeasured}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getSoluteProperties}()},
\code{\link{getWhatMeasured}()},
\code{\link{getWhenMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setFilterProperties}()},
\code{\link{setHowMeasured}()},
\code{\link{setInstrDesc}()},
\code{\link{setInstrSettings}()},
\code{\link{setSoluteProperties}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhenMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{spct_metadata}()},
\code{\link{subset_attributes}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
