% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phinterval.R
\name{is_hole}
\alias{is_hole}
\title{Test for empty intervals}
\usage{
is_hole(phint)
}
\arguments{
\item{phint}{\verb{[phinterval / Interval]}

A \verb{<phinterval>} or \verb{<Interval>} vector.}
}
\value{
A logical vector the same length as \code{phint}.
}
\description{
\code{is_hole()} checks for \verb{<hole>} (empty) time spans in \code{phint}.
}
\examples{
# Detect holes
y2000 <- interval(as.Date("2000-01-01"), as.Date("2001-01-01"))
y2025 <- interval(as.Date("2025-01-01"), as.Date("2025-01-01"))
is_hole(c(hole(), y2000, hole(), y2025, NA))

# The intersection of disjoint intervals is a hole
is_hole(phint_intersect(y2000, y2025))

}
