% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-postprob.r
\name{postprob}
\alias{postprob}
\title{The posterior probability criterion function}
\usage{
postprob(y, n, alpha_e, beta_e, alpha_s, beta_s, delta)
}
\arguments{
\item{y}{the number of responses among \eqn{n} patients treated by the experimental drug at a certain stage of the trial.}

\item{n}{the number of patients treated by the experimental drug at a certain stage of the trial.}

\item{alpha_e}{the hyperparameter (shape1) of the Beta prior for the experimental drug.}

\item{beta_e}{the hyperparameter (shape2) of the Beta prior for the experimental drug.}

\item{alpha_s}{the hyperparameter (shape1) of the Beta prior for the standard drug.}

\item{beta_s}{the hyperparameter (shape2) of the Beta prior for the standard drug.}

\item{delta}{the minimally acceptable increment of the response rate for the experimental drug compared with the standard drug.}
}
\value{
\item{prob}{the posterior probability: \eqn{\Pr(p_E > p_S + \delta | y)}}
}
\description{
Thall and Simon's criterion function for determining the
trial decision cutoffs based on the posterior probability.
}
\references{
Thall, P. F., Simon, R. (1994).
Practical Bayesian guidelines for phase IIB clinical trials.
\emph{Biometrics} \strong{50}: 337-349.

Yin, G. (2012).
\emph{Clinical Trial Design: Bayesian and Frequentist Adaptive Methods.}
New York: Wiley.
}
