% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_stats.R
\name{one_sample_mean}
\alias{one_sample_mean}
\title{Calculate the one-sample problem test statistic}
\usage{
one_sample_mean(df, group_col, outcome_col)
}
\arguments{
\item{df}{A data frame}

\item{group_col}{The name of the column in df that corresponds to the group label}

\item{outcome_col}{The name of the column in df that corresponds to the outcome variable}
}
\value{
The one-sample problem test statistic: the mean of the product of the outcome and group
}
\description{
This function takes a data frame, and group and outcome column names as input
and returns the mean of the product of the outcome and group. This test statistic
is used for the one-sample problem.
}
\examples{
data <- data.frame(group = c(rep(1, 4), rep(2, 4)),
                   outcome = c(rep(3, 4), rep(5, 4)))

one_sample_mean(df = data,
              group_col = "group",
              outcome_col = "outcome")

}
