% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_residues.R
\name{filter_residues}
\alias{filter_residues}
\title{Filter Peptides by Residue Counts}
\usage{
filter_residues(
  df,
  sequence_col = "Sequence",
  residues = c("A", "V", "I", "L", "G"),
  max_residues = 2
)
}
\arguments{
\item{df}{A data frame containing peptide sequences.}

\item{sequence_col}{The name of the column that contains the sequences.}

\item{residues}{A character vector of residues to count.}

\item{max_residues}{The maximum number of allowed residues.}
}
\value{
A filtered data frame.
}
\description{
This function counts the number of specified residues in each peptide sequence
and filters out the ones with more than the specified limit. It's defaults is
for filtering out small alliphatic residues.
}
\examples{
# Generate a mock data frame
peptide_data <- data.frame(Sequence = c("AVILG", "VILGA", "ILGAV", "LGAVI"))
# Apply the function to the mock data
filter_residues(peptide_data, residues = c("A", "V", "I", "L", "G"), max_residues = 2)
}
