% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_pensynth.R
\name{lambda_sequence}
\alias{lambda_sequence}
\title{Determine lambda sequence}
\usage{
lambda_sequence(X1VX0, Delta, nlambda)
}
\arguments{
\item{X1VX0}{the weighted cross-product matrix}

\item{Delta}{the matching penalty matrix}

\item{nlambda}{the number of lambda values}
}
\value{
lambda sequence as a numeric vector
}
\description{
This function uses the weighted cross-product matrix
(X1VX0) and Delta to determine the lambda sequence.
This sequence will be exponentially increasing so it
is easy to plot with a logarithmic x-axis
}
\details{
The formula for the maximum lambda value was determined
empirically, with an eye for the form of the quadratic
program. In general, the max lambda should be so large
that we are practically in "nearest-neighbour" matching
territory. This formula ensures this for a wide range
of input parameters.
}
\seealso{
\code{\link[=plot.cvpensynth]{plot.cvpensynth()}}
}
\keyword{internal}
