% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedigree.R
\name{getA}
\alias{getA}
\title{Additive relationship matrix}
\usage{
getA(ped, labs = NULL)
}
\arguments{
\item{ped}{\code{\link{pedigree}}}

\item{labs}{a character vector or a factor giving individual labels to
which to restrict the relationship matrix and corresponding factor. If
\code{labs} is a factor then the levels of the factor are used as the
labels. Default is the complete set of individuals in the pedigree.}
}
\value{
matrix (\code{\link[Matrix:dsCMatrix-class]{dsCMatrix}} - symmetric sparse)
}
\description{
Returns the additive relationship matrix for the pedigree.
}
\examples{
ped <- pedigree(sire = c(NA, NA, 1,  1, 4, 5),
                dam =  c(NA, NA, 2, NA, 3, 2),
                label = 1:6)
(A <- getA(ped))

# Test for correctness
AExp <- matrix(data = c(1.0000, 0.0000, 0.5000, 0.5000, 0.5000, 0.2500,
                        0.0000, 1.0000, 0.5000, 0.0000, 0.2500, 0.6250,
                        0.5000, 0.5000, 1.0000, 0.2500, 0.6250, 0.5625,
                        0.5000, 0.0000, 0.2500, 1.0000, 0.6250, 0.3125,
                        0.5000, 0.2500, 0.6250, 0.6250, 1.1250, 0.6875,
                        0.2500, 0.6250, 0.5625, 0.3125, 0.6875, 1.1250),
               byrow = TRUE, nrow = 6)
stopifnot(!any(abs(A - AExp) > .Machine$double.eps))
stopifnot(Matrix::isSymmetric(A))
}
