% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdfminer.R
\name{read.pdf}
\alias{read.pdf}
\title{Read a \code{PDF} document.}
\usage{
read.pdf(
  file,
  pages = integer(),
  method = c("csv", "sqlite", "PythonInR"),
  laycntrl = layout_control(),
  encoding = "utf8",
  password = "",
  caching = TRUE,
  maxpages = Inf,
  rotation = 0L,
  image_dir = "",
  pyexe = "python3"
)
}
\arguments{
\item{file}{a character string giving the name of the \code{PDF}-file the data are 
to be read from.}

\item{pages}{an integer giving the pages which should be extracted 
(default is \code{integer()}).}

\item{method}{a character string giving the data transfer method. Allowed values
are \code{"csv"} (default), \code{"sqlite"} and \code{"PythonInR"} (recommended).}

\item{laycntrl}{a list of layout options, created by the function \code{layout_control}.}

\item{encoding}{a character string giving the encoding of the output 
(default is \code{"utf8"}).}

\item{password}{a character string giving the password necessary to access 
the \code{PDF} (default is \code{""}).}

\item{caching}{a logical if \code{TRUE} (default) \pkg{pdfminer} is faster but 
uses more memory.}

\item{maxpages}{an integer giving the maximum number of pages to be extracted
(default is \code{Inf}).}

\item{rotation}{an integer giving the rotation of the page, allowed values
are \code{c(0, 90, 180, 270)}.}

\item{image_dir}{a character string giving the path to the folder, where the images
should be stored (default is \code{""}).}

\item{pyexe}{a character string giving the path to the python executable 
(default is \code{"python3"}). Only used when \code{method} is 
\code{"csv"} or \code{"sqlite"}.}
}
\value{
Returns a object of class \code{"pdf_document"}.
}
\description{
Extract  \code{PDF} document
}
\examples{
if (is_pdfminer_installed()) {
pdf_file <- system.file("pdfs/cars.pdf", package = "pdfminer")
read.pdf(pdf_file)
}
}
