% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassFunctions.R
\name{plot.Uniform}
\alias{plot.Uniform}
\title{Plot a \code{Uniform} \code{object}}
\usage{
\method{plot}{Uniform}(x, asp = NA, xlab = "x", ylab = "y", zlab = "z", ...)
}
\arguments{
\item{x}{Object of class \code{Uniform}.}

\item{asp}{A \code{numeric} value,
giving the aspect ratio for \eqn{y}-axis to \eqn{x}-axis
\eqn{y/x} for the 2D case,
it is redundant in the 3D case (default is \code{NA}),
see the official help for \code{asp} by typing "\code{? asp}".}

\item{xlab, ylab, zlab}{Titles for the \eqn{x} and \eqn{y} axes
in the 2D case,
and \eqn{x}, \eqn{y}, and \eqn{z} axes in the 3D case,
respectively (default is \code{xlab="x"}, \code{ylab="y"},
and \code{zlab="z"}).}

\item{\dots}{Additional parameters for \code{plot}.}
}
\value{
None
}
\description{
Plots the points generated from the uniform distribution
together with the support region
}
\examples{
\donttest{
n<-10 #try also 20, 100, and 1000
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C)

Xdt<-runif.tri(n,Tr)
Xdt
plot(Xdt,asp=1)
}

}
\seealso{
\code{\link{print.Uniform}},
\code{\link{summary.Uniform}},
and \code{\link{print.summary.Uniform}}
}
