% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArcSliceFunctions.R
\name{Idom.setAStri}
\alias{Idom.setAStri}
\title{The indicator for the set of points \code{S} being a dominating set or not for Arc Slice Proximity
Catch Digraphs (AS-PCDs) - one triangle case}
\usage{
Idom.setAStri(S, Xp, tri, M = "CC")
}
\arguments{
\item{S}{A set of 2D points which is to be tested for being a dominating set for the AS-PCDs.}

\item{Xp}{A set of 2D points which constitute the vertices of the AS-PCD.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{M}{The center of the triangle. \code{"CC"} stands for circumcenter of the triangle \code{tri} or a 2D point in Cartesian coordinates or
a 3D point in barycentric coordinates which serves as a center in the interior of \code{tri};
default is \code{M="CC"} i.e., the circumcenter of \code{tri}.}
}
\value{
\eqn{I(}\code{S} a dominating set of AS-PCD\eqn{)}, that is, returns 1 if \code{S} is a dominating set of AS-PCD whose
vertices are the data points in \code{Xp}; returns 0 otherwise, where AS proximity region is constructed in
the triangle \code{tri}.
}
\description{
Returns \eqn{I(}\code{S} a dominating set of AS-PCD\eqn{)}, that is, returns 1 if \code{S} is a dominating set of AS-PCD,
returns 0 otherwise.

AS-PCD has vertex set \code{Xp} and AS proximity region is constructed with vertex
regions are based on the center, \eqn{M=(m_1,m_2)} in Cartesian coordinates
or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of the triangle \code{tri}
or based on circumcenter of  \code{tri};
default is \code{M="CC"}, i.e., circumcenter of \code{tri}
whose vertices are also labeled as edges 1, 2, and 3, respectively.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
\donttest{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);

Tr<-rbind(A,B,C);
n<-10

set.seed(1)
Xp<-runif.tri(n,Tr)$gen.points

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.2)

S<-rbind(Xp[1,],Xp[2,])
Idom.setAStri(S,Xp,Tr,M)

S<-rbind(Xp[1,],Xp[2,],Xp[3,],Xp[5,])
Idom.setAStri(S,Xp,Tr,M)

S<-rbind(c(.1,.1),c(.3,.4),c(.5,.3))
Idom.setAStri(S,Xp,Tr,M)

Idom.setAStri(c(.2,.5),Xp,Tr,M)
Idom.setAStri(c(.2,.5),c(.2,.5),Tr,M)
Idom.setAStri(Xp[5,],Xp[2,],Tr,M)

S<-rbind(Xp[1,],Xp[2,],Xp[3,],Xp[5,],c(.2,.5))
Idom.setAStri(S,Xp[3,],Tr,M)

Idom.setAStri(Xp,Xp,Tr,M)

P<-c(.4,.2)
S<-Xp[c(1,3,4),]
Idom.setAStri(Xp,P,Tr,M)
Idom.setAStri(S,P,Tr,M)
Idom.setAStri(S,Xp,Tr,M)

Idom.setAStri(rbind(S,S),Xp,Tr,M)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IarcASset2pnt.tri}}, \code{\link{Idom.setPEtri}} and \code{\link{Idom.setCStri}}
}
\author{
Elvan Ceyhan
}
