% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge2D.R
\name{IarcPEset2pnt.tri}
\alias{IarcPEset2pnt.tri}
\title{The indicator for the presence of an arc from a point in set \code{S}
to the point \code{p} for Proportional Edge Proximity Catch Digraphs
(PE-PCDs) - one triangle case}
\usage{
IarcPEset2pnt.tri(S, p, tri, r, M = c(1, 1, 1))
}
\arguments{
\item{S}{A set of 2D points.
Presence of an arc from a point in \code{S} to point \code{p} is checked
by the function.}

\item{p}{A 2D point.
Presence of an arc from a point in \code{S} to point \code{p} is checked
by the function.}

\item{tri}{A \eqn{3 \times 2} matrix with each row
representing a vertex of the triangle.}

\item{r}{A positive real number
which serves as the expansion parameter in PE proximity region
constructed in the triangle \code{tri}; must be \eqn{\ge 1}.}

\item{M}{A 2D point in Cartesian coordinates
or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri}
or the circumcenter of \code{tri}
which may be entered as "CC" as well;
default is \eqn{M=(1,1,1)}, i.e., the center of mass of \code{tri}.}
}
\value{
\eqn{I(}\code{p} is in \eqn{U_{x in S} N_{PE}(x,r))},
that is, returns 1 if \code{p} is in \code{S}
or inside \eqn{N_{PE}(x,r)} for at least
one \eqn{x} in \code{S}, and returns 0 otherwise,
where PE proximity region is constructed
with respect to the triangle \code{tri}
}
\description{
Returns \eqn{I(}\code{p} in \eqn{N_{PE}(x,r)}
for some \eqn{x} in \code{S}\eqn{)},
that is, returns 1 if \code{p} is in \eqn{\cup_{x in S}N_{PE}(x,r)},
and returns 0 otherwise.

PE proximity region is constructed
with respect to the triangle \code{tri} with
the expansion parameter \eqn{r \ge 1}
and vertex regions are based on the center, \eqn{M=(m_1,m_2)}
in Cartesian coordinates
or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of the triangle \code{tri}
or based on the circumcenter of \code{tri};
 default is \eqn{M=(1,1,1)}, i.e.,
 the center of mass of \code{tri}.
Vertices of \code{tri} are also labeled as 1, 2, and 3,
respectively.

If \code{p} is not in \code{S} and either \code{p}
or all points in \code{S} are outside \code{tri}, it returns 0,
but if \code{p} is in \code{S},
then it always returns 1 regardless of its location
(i.e., loops are allowed).
}
\examples{
\donttest{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10

set.seed(1)
Xp<-runif.tri(n,Tr)$gen.points

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.0)

r<-1.5

S<-rbind(Xp[1,],Xp[2,])  #try also S<-c(1.5,1)

IarcPEset2pnt.tri(S,Xp[3,],Tr,r,M)
IarcPEset2pnt.tri(S,Xp[3,],r=1,Tr,M)

S<-rbind(Xp[1,],Xp[2,],Xp[3,],Xp[5,])
IarcPEset2pnt.tri(S,Xp[3,],Tr,r,M)

S<-rbind(c(.1,.1),c(.3,.4),c(.5,.3))
IarcPEset2pnt.tri(S,Xp[3,],Tr,r,M)

P<-c(.4,.2)
S<-Xp[c(1,3,4),]
IarcPEset2pnt.tri(Xp,P,Tr,r,M)
}

}
\seealso{
\code{\link{IarcPEset2pnt.std.tri}}, \code{\link{IarcPEtri}},
\code{\link{IarcPEstd.tri}}, \code{\link{IarcASset2pnt.tri}},
and \code{\link{IarcCSset2pnt.tri}}
}
\author{
Elvan Ceyhan
}
