% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UndClassFunctions.R
\name{plot.UndPCDs}
\alias{plot.UndPCDs}
\title{Plot an \code{UndPCDs} \code{object}}
\usage{
\method{plot}{UndPCDs}(x, Jit = 0.1, ...)
}
\arguments{
\item{x}{Object of class \code{UndPCDs}.}

\item{Jit}{A positive real number
that determines the amount of jitter along the \eqn{y}-axis,
default is 0.1, for the 1D case,
the vertices of the PCD are jittered
according to \eqn{U(-Jit,Jit)} distribution
along the \eqn{y}-axis where
\code{Jit} equals to the range of vertices
and the interval end points;
it is redundant in the 2D case.}

\item{\dots}{Additional parameters for \code{plot}.}
}
\value{
None
}
\description{
Plots the vertices and the edges
of the underlying or reflexivity graphs
of the PCD together with the vertices
and boundaries of the partition
cells (i.e., intervals in the 1D case
and triangles in the 2D case)
}
\examples{
#\donttest{
nx<-20; ny<-5;
set.seed(1)
Xp<-cbind(runif(nx,0,1),runif(nx,0,1))
Yp<-cbind(runif(ny,0,.25),runif(ny,0,.25))+cbind(c(0,0,0.5,1,1),c(0,1,.5,0,1))
M<-c(1,1,1)  #try also M<-c(1,2,3)
r<-1.5
Edges<-edgesPE(Xp,Yp,r,M)
Edges
plot(Edges)
#}

}
\seealso{
\code{\link{print.UndPCDs}}, \code{\link{summary.UndPCDs}},
and \code{\link{print.summary.UndPCDs}}
}
