% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UndClassFunctions.R
\name{plot.NumEdges}
\alias{plot.NumEdges}
\title{Plot a \code{NumEdges} \code{object}}
\usage{
\method{plot}{NumEdges}(x, Jit = 0.1, ...)
}
\arguments{
\item{x}{Object of class \code{NumEdges}.}

\item{Jit}{A positive real number
that determines the amount of jitter along the \eqn{y}-axis,
default is 0.1, for the 1D case,
the vertices of the underlying or reflexivity graph of the PCD are jittered
according to \eqn{U(-Jit,Jit)} distribution
along the \eqn{y}-axis where
\code{Jit} equals to the range of vertices
and the interval end points; it is redundant in the 2D case.}

\item{\dots}{Additional parameters for \code{plot}.}
}
\value{
None
}
\description{
Plots the scatter plot of the data points (i.e. vertices of the
underlying or reflexivity graphs of the PCDs)
and the Delaunay tessellation of the nontarget points marked with number of edges
in the centroid of the Delaunay cells.
}
\examples{
#\donttest{
nx<-15; ny<-5;
set.seed(1)
Xp<-cbind(runif(nx),runif(nx))
Yp<-cbind(runif(ny,0,.25),
runif(ny,0,.25))+cbind(c(0,0,0.5,1,1),c(0,1,.5,0,1))

M<-c(1,1,1)  #try also M<-c(1,2,3)

Nedges = num.edgesAS(Xp,Yp,M)
Nedges
plot(Nedges)
#}

}
\seealso{
\code{\link{print.NumEdges}}, \code{\link{summary.NumEdges}},
and \code{\link{print.summary.NumEdges}}
}
