% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArcSliceUGFunctions.R
\name{num.edgesAS}
\alias{num.edgesAS}
\title{Number of edges of
the underlying or reflexivity graph of
Arc Slice Proximity Catch Digraphs (AS-PCDs) -
multiple triangle case}
\usage{
num.edgesAS(Xp, Yp, M = "CC", ugraph = c("underlying", "reflexivity"))
}
\arguments{
\item{Xp}{A set of 2D points
which constitute the vertices of the underlying
or reflexivity graph of the AS-PCD.}

\item{Yp}{A set of 2D points
which constitute the vertices of the Delaunay triangles.}

\item{M}{The center of the triangle.
\code{"CC"} stands for circumcenter of each Delaunay triangle
or 3D point in barycentric
coordinates which serves as a center
in the interior of each Delaunay triangle;
default is \code{M="CC"}, i.e., the circumcenter of each triangle.}

\item{ugraph}{The type of the graph based on AS-PCDs,
\code{"underlying"} is for the underlying graph, and \code{"reflexivity"} is for
the reflexivity graph (default is \code{"underlying"}).}
}
\value{
A \code{list} with the elements
\item{desc}{A short description of the output: number of edges
and related quantities for the induced subgraphs of the underlying
or reflexivity graphs (of AS-PCD) in the Delaunay triangles}
\item{und.graph}{Type of the graph as "Underlying" or "Reflexivity" for the AS-PCD}
\item{num.edges}{Total number of edges in all triangles,
i.e., the number of edges for the entire underlying
or reflexivity graphs of the AS-PCD}
\item{num.in.conv.hull}{Number of \code{Xp} points
in the convex hull of \code{Yp} points}
\item{num.in.tris}{The vector of number of \code{Xp} points
in the Delaunay triangles based on \code{Yp} points}
\item{weight.vec}{The \code{vector} of the areas of
Delaunay triangles based on \code{Yp} points}
\item{tri.num.edges}{The \code{vector} of the number of edges
of the components of the AS-PCD in the
Delaunay triangles based on \code{Yp} points}
\item{del.tri.ind}{A matrix of indices of vertices of
the Delaunay triangles based on \code{Yp} points,
each column corresponds to the vector of
indices of the vertices of one triangle.}
\item{data.tri.ind}{A \code{vector} of indices of vertices of
the Delaunay triangles in which data points reside,
i.e., column number of \code{del.tri.ind} for each \code{Xp} point.}
\item{tess.points}{Points on which the tessellation of the study region is performed,
here, tessellation is the Delaunay triangulation based on \code{Yp} points.}
\item{vertices}{Vertices of the underlying or reflexivity graph, \code{Xp}.}
}
\description{
An object of class \code{"NumEdges"}.
Returns the number of edges of
the underlying or reflexivity graph of
Arc Slice Proximity Catch Digraph (AS-PCD)
and various other quantities and vectors such as
the vector of number of vertices (i.e., number of data points)
in the Delaunay triangles,
number of data points in the convex hull of \code{Yp} points,
indices of the Delaunay triangles for the data points, etc.

AS proximity regions are defined with respect to the
Delaunay triangles based on \code{Yp} points
and vertex regions in each triangle are based on the center \code{M="CC"}
for circumcenter of each Delaunay triangle
or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the
interior of each Delaunay triangle;
default is \code{M="CC"}, i.e., circumcenter of each triangle.
Each Delaunay triangle is first converted to
a (nonscaled) basic triangle so that \code{M} will be the same
type of center for each Delaunay triangle
(this conversion is not necessary when \code{M} is \eqn{CM}).

Convex hull of \code{Yp} is partitioned
by the Delaunay triangles based on \code{Yp} points
(i.e., multiple triangles are the set of these Delaunay triangles
whose union constitutes the
convex hull of \code{Yp} points).
For the number of edges,
loops are not allowed so edges are only possible
for points inside the convex hull of \code{Yp} points.

See (\insertCite{ceyhan:Phd-thesis,ceyhan:stamet2016;textual}{pcds.ugraph})
for more on AS-PCDs.
Also, see (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds.ugraph})
for more on Delaunay triangulation and the corresponding algorithm.
}
\examples{
#\donttest{
#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-15; ny<-5;

set.seed(1)
Xp<-cbind(runif(nx),runif(nx))
Yp<-cbind(runif(ny,0,.25),
runif(ny,0,.25))+cbind(c(0,0,0.5,1,1),c(0,1,.5,0,1))

pcds::plotDelaunay.tri(Xp,Yp,xlab="",ylab="")

M<-c(1,1,1)

Nedges = num.edgesAS(Xp,Yp,M)
Nedges
summary(Nedges)
plot(Nedges)
#}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{num.edgesAStri}}, \code{\link{num.edgesPE}},
\code{\link{num.edgesCS}}, and \code{\link[pcds]{num.arcsAS}}
}
\author{
Elvan Ceyhan
}
