% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cv.pcLasso.R
\name{plot.cv.pcLasso}
\alias{plot.cv.pcLasso}
\title{Plot the cross-validation curve produced by "cv.pcLasso" object}
\usage{
\method{plot}{cv.pcLasso}(x, sign.lambda = 1, orignz = TRUE, ...)
}
\arguments{
\item{x}{Fitted "\code{cv.pcLasso}" object.}

\item{sign.lambda}{Either plot against \code{log(lambda)} (default) or
\code{-log(lambda)} (if \code{sign.lambda = -1}).}

\item{orignz}{If \code{TRUE} (default), prints the number of non-zero
coefficients in the original feature space. If not, prints the number of
non-zero coefficients in the expanded feature space. No effect if groups are
not overlapping.}

\item{...}{Other graphical paramters to plot.}
}
\description{
Plots the cross-validation curve produced by a \code{cv.pcLasso} object, along
with upper and lower standard deviation curves, as a function of the \code{lambda}
values used.
}
\details{
A plot is produced and nothing is returned.
}
\examples{
set.seed(1)
x <- matrix(rnorm(100 * 20), 100, 20)
y <- rnorm(100)
groups <- vector("list", 4)
for (k in 1:4) {
    groups[[k]] <- 5 * (k-1) + 1:5
}
cvfit <- cv.pcLasso(x, y, ratio = 0.8, groups = groups)
plot(cvfit)
# plot flipped: x-axis tracks -log(lambda) instead
plot(cvfit, sign.lambda = -1)

# if groups overlap, orignz can be used to decide which space to count the
# number of non-zero coefficients at the top
groups[[1]] <- 1:8
cvfit <- cv.pcLasso(x, y, ratio = 0.8, groups = groups)
plot(cvfit)                  # no. of non-zero coefficients in original space
plot(cvfit, orignz = FALSE)  # no. of non-zero coefficients in expanded space

}
\seealso{
\code{\link{pcLasso}} and \code{\link{cv.pcLasso}}.
}
