% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{calibrateItems}
\alias{calibrateItems}
\title{Determine the optimal scale constant for a set of items}
\usage{
calibrateItems(
  df,
  iter = 2000L,
  chains = 4L,
  varCorrection = 5,
  maxAttempts = 5L,
  ...
)
}
\arguments{
\item{df}{a data frame with pairs of vertices given in columns \code{pa1} and \code{pa2}, and item response data in other columns}

\item{iter}{A positive integer specifying the number of iterations for each chain (including warmup).}

\item{chains}{A positive integer specifying the number of Markov chains.}

\item{varCorrection}{A correction factor greater than or equal to 1.0}

\item{maxAttempts}{How many times to try re-running a model with more iterations.}

\item{...}{Additional options passed to \code{\link[rstan]{stan}}.}
}
\value{
A data.frame (one row per item) with the following columns:
\describe{
 \item{item}{Name of the item}
 \item{iter}{Number of iterations per chain}
 \item{divergent}{Number of divergent transitions observed after warmup}
 \item{treedepth}{Number of times the treedepth was exceeded}
 \item{low_bfmi}{Number of chains with low E-BFMI}
 \item{n_eff}{Minimum effective number of samples across all parameters}
 \item{Rhat}{Maximum Rhat across all parameters}
 \item{scale}{Median marginal posterior of \code{scale}}
 \item{thetaVar}{Median variance of theta (latent scores)}
 }
}
\description{
Data are passed through \code{\link{filterGraph}} and \code{\link{normalizeData}}.
Then the \sQuote{unidim_adapt} model is fit to each item individually.
A larger \code{varCorrection} will obtain a more accurate
\code{scale}, but is also more likely to produce an intractable
model. A good compromise is between 5.0 and 9.0.
}
\examples{
\donttest{
result <- calibrateItems(phyActFlowPropensity)  # takes more than 5 seconds
print(result)
}
}
\references{
Vehtari, A., Gelman, A., Simpson, D., Carpenter, B., & Bürkner, P. C. (2019). Rank-normalization, folding, and localization: An improved \eqn{\widehat R} for assessing convergence of MCMC. arXiv preprint arXiv:1903.08008.
}
\seealso{
\code{\link[rstan:check_hmc_diagnostics]{check_hmc_diagnostics}}
}
