% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbetareg.R
\name{pbetareg}
\alias{pbetareg}
\title{Profile Boosting for Beta Regression}
\usage{
pbetareg(
  formula,
  data,
  subset,
  na.action,
  weights,
  offset,
  link = c("logit", "probit", "cloglog", "cauchit", "log", "loglog"),
  link.phi = NULL,
  type = c("ML", "BC", "BR"),
  dist = NULL,
  nu = NULL,
  control = betareg.control(...),
  model = TRUE,
  y = TRUE,
  x = FALSE,
  ...,
  stopFun = EBIC,
  keep = NULL,
  maxK = NULL,
  verbose = FALSE
)
}
\arguments{
\item{formula}{See \link{pboost}.}

\item{data}{See \link{pboost}.}

\item{subset}{Parameters passed to \link[betareg:betareg]{betareg::betareg}.}

\item{na.action}{Parameters passed to \link[betareg:betareg]{betareg::betareg}.}

\item{weights}{Parameters passed to \link[betareg:betareg]{betareg::betareg}.}

\item{offset}{Parameters passed to \link[betareg:betareg]{betareg::betareg}.}

\item{link}{Parameters passed to \link[betareg:betareg]{betareg::betareg}.}

\item{link.phi}{Parameters passed to \link[betareg:betareg]{betareg::betareg}.}

\item{type}{Parameters passed to \link[betareg:betareg]{betareg::betareg}.}

\item{dist}{Parameters passed to \link[betareg:betareg]{betareg::betareg}.}

\item{nu}{Parameters passed to \link[betareg:betareg]{betareg::betareg}.}

\item{control}{Parameters passed to \link[betareg:betareg]{betareg::betareg}.}

\item{model}{Parameters passed to \link[betareg:betareg]{betareg::betareg}.}

\item{y}{Parameters passed to \link[betareg:betareg]{betareg::betareg}.}

\item{x}{Parameters passed to \link[betareg:betareg]{betareg::betareg}.}

\item{...}{Parameters passed to \link[betareg:betareg]{betareg::betareg}.}

\item{stopFun}{Parameters passed to \link{pboost}.}

\item{keep}{Parameters passed to \link{pboost}.}

\item{maxK}{Parameters passed to \link{pboost}.}

\item{verbose}{Parameters passed to \link{pboost}.}
}
\value{
An \code{betareg} model object fitted on the selected features.
}
\description{
\link{pbetareg} inherits the usage of \link[betareg:betareg]{betareg::betareg}.
}
\examples{
\donttest{
library(betareg)
set.seed(2025)
n <- 300
p <- 100
x <- matrix(runif(n*p), n)
mu <- runif(n)
phi <- 1.0

shape1 <- mu * phi
shape2 <- (1-mu) * phi
y <- rbeta(n, shape1, shape2)
DF <- data.frame(y, x)

pbetareg(y ~ ., DF, verbose=TRUE)
}

}
