# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS ARC - Zonal Shift
#'
#' @description
#' Welcome to the API Reference Guide for zonal shift and zonal autoshift
#' in Amazon Route 53 Application Recovery Controller (Route 53 ARC).
#' 
#' You can start a zonal shift to move traffic for a load balancer resource
#' away from an Availability Zone to help your application recover quickly
#' from an impairment in an Availability Zone. For example, you can recover
#' your application from a developer's bad code deployment or from an
#' Amazon Web Services infrastructure failure in a single Availability
#' Zone.
#' 
#' You can also configure zonal autoshift for supported load balancer
#' resources. Zonal autoshift is a capability in Route 53 ARC where you
#' authorize Amazon Web Services to shift away application resource traffic
#' from an Availability Zone during events, on your behalf, to help reduce
#' your time to recovery. Amazon Web Services starts an autoshift when
#' internal telemetry indicates that there is an Availability Zone
#' impairment that could potentially impact customers.
#' 
#' To help make sure that zonal autoshift is safe for your application, you
#' must also configure practice runs when you enable zonal autoshift for a
#' resource. Practice runs start weekly zonal shifts for a resource, to
#' shift traffic for the resource away from an Availability Zone. Practice
#' runs help you to make sure, on a regular basis, that you have enough
#' capacity in all the Availability Zones in an Amazon Web Services Region
#' for your application to continue to operate normally when traffic for a
#' resource is shifted away from one Availability Zone.
#' 
#' Before you configure practice runs or enable zonal autoshift, we
#' strongly recommend that you prescale your application resource capacity
#' in all Availability Zones in the Region where your application resources
#' are deployed. You should not rely on scaling on demand when an autoshift
#' or practice run starts. Zonal autoshift, including practice runs, works
#' independently, and does not wait for auto scaling actions to complete.
#' Relying on auto scaling, instead of pre-scaling, can result in loss of
#' availability.
#' 
#' If you use auto scaling to handle regular cycles of traffic, we strongly
#' recommend that you configure the minimum capacity of your auto scaling
#' to continue operating normally with the loss of an Availability Zone.
#' 
#' Be aware that Route 53 ARC does not inspect the health of individual
#' resources. Amazon Web Services only starts an autoshift when Amazon Web
#' Services telemetry detects that there is an Availability Zone impairment
#' that could potentially impact customers. In some cases, resources might
#' be shifted away that are not experiencing impact.
#' 
#' For more information about using zonal shift and zonal autoshift, see
#' the [Amazon Route 53 Application Recovery Controller Developer
#' Guide](https://docs.aws.amazon.com/r53recovery/latest/dg/what-is-route53-recovery.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- arczonalshift(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- arczonalshift()
#' svc$cancel_zonal_shift(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=arczonalshift_cancel_zonal_shift]{cancel_zonal_shift} \tab Cancel a zonal shift in Amazon Route 53 Application Recovery Controller\cr
#'  \link[=arczonalshift_create_practice_run_configuration]{create_practice_run_configuration} \tab A practice run configuration for zonal autoshift is required when you enable zonal autoshift\cr
#'  \link[=arczonalshift_delete_practice_run_configuration]{delete_practice_run_configuration} \tab Deletes the practice run configuration for a resource\cr
#'  \link[=arczonalshift_get_autoshift_observer_notification_status]{get_autoshift_observer_notification_status} \tab Returns the status of autoshift observer notification\cr
#'  \link[=arczonalshift_get_managed_resource]{get_managed_resource} \tab Get information about a resource that's been registered for zonal shifts with Amazon Route 53 Application Recovery Controller in this Amazon Web Services Region\cr
#'  \link[=arczonalshift_list_autoshifts]{list_autoshifts} \tab Returns a list of autoshifts for an Amazon Web Services Region\cr
#'  \link[=arczonalshift_list_managed_resources]{list_managed_resources} \tab Lists all the resources in your Amazon Web Services account in this Amazon Web Services Region that are managed for zonal shifts in Amazon Route 53 Application Recovery Controller, and information about them\cr
#'  \link[=arczonalshift_list_zonal_shifts]{list_zonal_shifts} \tab Lists all active and completed zonal shifts in Amazon Route 53 Application Recovery Controller in your Amazon Web Services account in this Amazon Web Services Region\cr
#'  \link[=arczonalshift_start_zonal_shift]{start_zonal_shift} \tab You start a zonal shift to temporarily move load balancer traffic away from an Availability Zone in an Amazon Web Services Region, to help your application recover immediately, for example, from a developer's bad code deployment or from an Amazon Web Services infrastructure failure in a single Availability Zone\cr
#'  \link[=arczonalshift_update_autoshift_observer_notification_status]{update_autoshift_observer_notification_status} \tab Update the status of autoshift observer notification\cr
#'  \link[=arczonalshift_update_practice_run_configuration]{update_practice_run_configuration} \tab Update a practice run configuration to change one or more of the following: add, change, or remove the blocking alarm; change the outcome alarm; or add, change, or remove blocking dates or time windows\cr
#'  \link[=arczonalshift_update_zonal_autoshift_configuration]{update_zonal_autoshift_configuration} \tab The zonal autoshift configuration for a resource includes the practice run configuration and the status for running autoshifts, zonal autoshift status\cr
#'  \link[=arczonalshift_update_zonal_shift]{update_zonal_shift} \tab Update an active zonal shift in Amazon Route 53 Application Recovery Controller in your Amazon Web Services account
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname arczonalshift
#' @export
arczonalshift <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .arczonalshift$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.arczonalshift <- list()

.arczonalshift$operations <- list()

.arczonalshift$metadata <- list(
  service_name = "arczonalshift",
  endpoints = list("^(us|eu|ap|sa|ca|me|af|il|mx)\\-\\w+\\-\\d+$" = list(endpoint = "arc-zonal-shift.{region}.amazonaws.com", global = FALSE), "^cn\\-\\w+\\-\\d+$" = list(endpoint = "arc-zonal-shift.{region}.amazonaws.com.cn", global = FALSE), "^us\\-gov\\-\\w+\\-\\d+$" = list(endpoint = "arc-zonal-shift.{region}.amazonaws.com", global = FALSE), "^us\\-iso\\-\\w+\\-\\d+$" = list(endpoint = "arc-zonal-shift.{region}.c2s.ic.gov", global = FALSE), "^us\\-isob\\-\\w+\\-\\d+$" = list(endpoint = "arc-zonal-shift.{region}.sc2s.sgov.gov", global = FALSE), "^eu\\-isoe\\-\\w+\\-\\d+$" = list(endpoint = "arc-zonal-shift.{region}.cloud.adc-e.uk", global = FALSE), "^us\\-isof\\-\\w+\\-\\d+$" = list(endpoint = "arc-zonal-shift.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "ARC Zonal Shift",
  api_version = "2022-10-30",
  signing_name = "arc-zonal-shift",
  json_version = "1.1",
  target_prefix = ""
)

.arczonalshift$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.arczonalshift$metadata, handlers, config, op)
}
