% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrockagent_operations.R
\name{bedrockagent_create_prompt_version}
\alias{bedrockagent_create_prompt_version}
\title{Creates a static snapshot of your prompt that can be deployed to
production}
\usage{
bedrockagent_create_prompt_version(
  clientToken = NULL,
  description = NULL,
  promptIdentifier,
  tags = NULL
)
}
\arguments{
\item{clientToken}{A unique, case-sensitive identifier to ensure that the API request
completes no more than one time. If this token matches a previous
request, Amazon Bedrock ignores the request, but does not return an
error. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}.}

\item{description}{A description for the version of the prompt.}

\item{promptIdentifier}{[required] The unique identifier of the prompt that you want to create a version
of.}

\item{tags}{Any tags that you want to attach to the version of the prompt. For more
information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html}{Tagging resources in Amazon Bedrock}.}
}
\description{
Creates a static snapshot of your prompt that can be deployed to production. For more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-deploy.html}{Deploy prompts using Prompt management by creating versions} in the Amazon Bedrock User Guide.

See \url{https://www.paws-r-sdk.com/docs/bedrockagent_create_prompt_version/} for full documentation.
}
\keyword{internal}
