% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workmail_operations.R
\name{workmail_put_identity_provider_configuration}
\alias{workmail_put_identity_provider_configuration}
\title{Enables integration between IAM Identity Center (IdC) and WorkMail to
proxy authentication requests for mailbox users}
\usage{
workmail_put_identity_provider_configuration(
  OrganizationId,
  AuthenticationMode,
  IdentityCenterConfiguration,
  PersonalAccessTokenConfiguration
)
}
\arguments{
\item{OrganizationId}{[required] The ID of the WorkMail Organization.}

\item{AuthenticationMode}{[required] The authentication mode used in WorkMail.}

\item{IdentityCenterConfiguration}{[required] The details of the IAM Identity Center configuration.}

\item{PersonalAccessTokenConfiguration}{[required] The details of the Personal Access Token configuration.}
}
\description{
Enables integration between IAM Identity Center (IdC) and WorkMail to proxy authentication requests for mailbox users. You can connect your IdC directory or your external directory to WorkMail through IdC and manage access to WorkMail mailboxes in a single place. For enhanced protection, you could enable Multifactor Authentication (MFA) and Personal Access Tokens.

See \url{https://www.paws-r-sdk.com/docs/workmail_put_identity_provider_configuration/} for full documentation.
}
\keyword{internal}
