% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chatbot_operations.R
\name{chatbot_create_microsoft_teams_channel_configuration}
\alias{chatbot_create_microsoft_teams_channel_configuration}
\title{Creates an AWS Chatbot configuration for Microsoft Teams}
\usage{
chatbot_create_microsoft_teams_channel_configuration(
  ChannelId,
  ChannelName = NULL,
  TeamId,
  TeamName = NULL,
  TenantId,
  SnsTopicArns = NULL,
  IamRoleArn,
  ConfigurationName,
  LoggingLevel = NULL,
  GuardrailPolicyArns = NULL,
  UserAuthorizationRequired = NULL,
  Tags = NULL
)
}
\arguments{
\item{ChannelId}{[required] The ID of the Microsoft Teams channel.}

\item{ChannelName}{The name of the Microsoft Teams channel.}

\item{TeamId}{[required] The ID of the Microsoft Teams authorized with AWS Chatbot.

To get the team ID, you must perform the initial authorization flow with
Microsoft Teams in the AWS Chatbot console. Then you can copy and paste
the team ID from the console. For more information, see \href{https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html#teams-client-setup}{Step 1: Configure a Microsoft Teams client}
in the \emph{AWS Chatbot Administrator Guide}.}

\item{TeamName}{The name of the Microsoft Teams Team.}

\item{TenantId}{[required] The ID of the Microsoft Teams tenant.}

\item{SnsTopicArns}{The Amazon Resource Names (ARNs) of the SNS topics that deliver
notifications to AWS Chatbot.}

\item{IamRoleArn}{[required] A user-defined role that AWS Chatbot assumes. This is not the
service-linked role.

For more information, see \href{https://docs.aws.amazon.com/chatbot/latest/adminguide/chatbot-iam-policies.html}{IAM policies for AWS Chatbot}
in the \emph{AWS Chatbot Administrator Guide}.}

\item{ConfigurationName}{[required] The name of the configuration.}

\item{LoggingLevel}{Logging levels include \code{ERROR}, \code{INFO}, or \code{NONE}.}

\item{GuardrailPolicyArns}{The list of IAM policy ARNs that are applied as channel guardrails. The
AWS managed \code{AdministratorAccess} policy is applied by default if this
is not set.}

\item{UserAuthorizationRequired}{Enables use of a user role requirement in your chat configuration.}

\item{Tags}{A map of tags assigned to a resource. A tag is a string-to-string map of
key-value pairs.}
}
\description{
Creates an AWS Chatbot configuration for Microsoft Teams.

See \url{https://www.paws-r-sdk.com/docs/chatbot_create_microsoft_teams_channel_configuration/} for full documentation.
}
\keyword{internal}
