% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloud9_operations.R
\name{cloud9_update_environment}
\alias{cloud9_update_environment}
\title{Changes the settings of an existing Cloud9 development environment}
\usage{
cloud9_update_environment(
  environmentId,
  name = NULL,
  description = NULL,
  managedCredentialsAction = NULL
)
}
\arguments{
\item{environmentId}{[required] The ID of the environment to change settings.}

\item{name}{A replacement name for the environment.}

\item{description}{Any new or replacement description for the environment.}

\item{managedCredentialsAction}{Allows the environment owner to turn on or turn off the Amazon Web
Services managed temporary credentials for an Cloud9 environment by
using one of the following values:
\itemize{
\item \code{ENABLE}
\item \code{DISABLE}
}

Only the environment owner can change the status of managed temporary
credentials. An \code{AccessDeniedException} is thrown if an attempt to turn
on or turn off managed temporary credentials is made by an account
that's not the environment owner.}
}
\description{
Changes the settings of an existing Cloud9 development environment.

See \url{https://www.paws-r-sdk.com/docs/cloud9_update_environment/} for full documentation.
}
\keyword{internal}
