% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_custom.R
\name{rds_build_auth_token}
\alias{rds_build_auth_token}
\title{Return an authentication token for a database connection}
\usage{
rds_build_auth_token(endpoint, user, creds = NULL, region = NULL)
}
\arguments{
\item{endpoint}{[required] Hostname and port needed to connect
to the database: \verb{<host>:<port>}.}

\item{user}{[required] User account within the database to sign in
with.}

\item{creds}{Credentials to be signed with.}

\item{region}{AWS region the database is located in.}
}
\description{
Return an authentication token used as the password for a database connection.
}
\details{
See \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html}{\emph{IAM Database Authentication for MySQL and PostgreSQL}}
for more information on using IAM database authentication with RDS.
}
\section{Request syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc$build_auth_token(
  endpoint = "string",
  region = "string",
  user = "string",
  creds = list(
    access_key_id = "string",
    secret_access_key = "string",
    session_token = "string"
  )
)
}\if{html}{\out{</div>}}
}

\examples{
\dontrun{
# This example gets an authentication token for an RDS database, then
# connects to the database using the token.
host <- "database-1.cluster-abcdef123456.us-east-1.rds.amazonaws.com"
port <- 3306
user <- "jane_doe"
token <- svc$build_auth_token(
  endpoint = sprintf("\%s:\%s", host, port),
  region = "us-east-1",
  user = user
)
conn <- DBI::dbConnect(
  drv = RMariaDB::MariaDB(),
  user = user,
  password = token,
  host = host,
  port = port,
  client.flag = RMariaDB::CLIENT_SSL
)
}

}
\seealso{
\link[paws.database:rds_build_auth_token_v2]{rds_build_auth_token_v2}
}
\keyword{internal}
