% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opensearchingestion_operations.R
\name{opensearchingestion_update_pipeline}
\alias{opensearchingestion_update_pipeline}
\title{Updates an OpenSearch Ingestion pipeline}
\usage{
opensearchingestion_update_pipeline(
  PipelineName,
  MinUnits = NULL,
  MaxUnits = NULL,
  PipelineConfigurationBody = NULL,
  LogPublishingOptions = NULL,
  BufferOptions = NULL,
  EncryptionAtRestOptions = NULL
)
}
\arguments{
\item{PipelineName}{[required] The name of the pipeline to update.}

\item{MinUnits}{The minimum pipeline capacity, in Ingestion Compute Units (ICUs).}

\item{MaxUnits}{The maximum pipeline capacity, in Ingestion Compute Units (ICUs)}

\item{PipelineConfigurationBody}{The pipeline configuration in YAML format. The command accepts the
pipeline configuration as a string or within a .yaml file. If you
provide the configuration as a string, each new line must be escaped
with \verb{\\\\n}.}

\item{LogPublishingOptions}{Key-value pairs to configure log publishing.}

\item{BufferOptions}{Key-value pairs to configure persistent buffering for the pipeline.}

\item{EncryptionAtRestOptions}{Key-value pairs to configure encryption for data that is written to a
persistent buffer.}
}
\description{
Updates an OpenSearch Ingestion pipeline. For more information, see \href{https://docs.aws.amazon.com/opensearch-service/latest/developerguide/update-pipeline.html}{Updating Amazon OpenSearch Ingestion pipelines}.

See \url{https://www.paws-r-sdk.com/docs/opensearchingestion_update_pipeline/} for full documentation.
}
\keyword{internal}
