% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis_operations.R
\name{kinesis_update_shard_count}
\alias{kinesis_update_shard_count}
\title{Updates the shard count of the specified stream to the specified number
of shards}
\usage{
kinesis_update_shard_count(
  StreamName = NULL,
  TargetShardCount,
  ScalingType,
  StreamARN = NULL
)
}
\arguments{
\item{StreamName}{The name of the stream.}

\item{TargetShardCount}{[required] The new number of shards. This value has the following default limits.
By default, you cannot do the following:
\itemize{
\item Set this value to more than double your current shard count for a
stream.
\item Set this value below half your current shard count for a stream.
\item Set this value to more than 10000 shards in a stream (the default
limit for shard count per stream is 10000 per account per region),
unless you request a limit increase.
\item Scale a stream with more than 10000 shards down unless you set this
value to less than 10000 shards.
}}

\item{ScalingType}{[required] The scaling type. Uniform scaling creates shards of equal size.}

\item{StreamARN}{The ARN of the stream.}
}
\description{
Updates the shard count of the specified stream to the specified number of shards. This API is only supported for the data streams with the provisioned capacity mode.

See \url{https://www.paws-r-sdk.com/docs/kinesis_update_shard_count/} for full documentation.
}
\keyword{internal}
