% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis_operations.R
\name{kinesis_describe_stream}
\alias{kinesis_describe_stream}
\title{Describes the specified Kinesis data stream}
\usage{
kinesis_describe_stream(
  StreamName = NULL,
  Limit = NULL,
  ExclusiveStartShardId = NULL,
  StreamARN = NULL
)
}
\arguments{
\item{StreamName}{The name of the stream to describe.}

\item{Limit}{The maximum number of shards to return in a single call. The default
value is 100. If you specify a value greater than 100, at most 100
results are returned.}

\item{ExclusiveStartShardId}{The shard ID of the shard to start with.

Specify this parameter to indicate that you want to describe the stream
starting with the shard whose ID immediately follows
\code{ExclusiveStartShardId}.

If you don't specify this parameter, the default behavior for
\code{\link[=kinesis_describe_stream]{describe_stream}} is to describe the stream
starting with the first shard in the stream.}

\item{StreamARN}{The ARN of the stream.}
}
\description{
Describes the specified Kinesis data stream.

See \url{https://www.paws-r-sdk.com/docs/kinesis_describe_stream/} for full documentation.
}
\keyword{internal}
