% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendra_operations.R
\name{kendra_update_data_source}
\alias{kendra_update_data_source}
\title{Updates an Amazon Kendra data source connector}
\usage{
kendra_update_data_source(
  Id,
  Name = NULL,
  IndexId,
  Configuration = NULL,
  VpcConfiguration = NULL,
  Description = NULL,
  Schedule = NULL,
  RoleArn = NULL,
  LanguageCode = NULL,
  CustomDocumentEnrichmentConfiguration = NULL
)
}
\arguments{
\item{Id}{[required] The identifier of the data source connector you want to update.}

\item{Name}{A new name for the data source connector.}

\item{IndexId}{[required] The identifier of the index used with the data source connector.}

\item{Configuration}{Configuration information you want to update for the data source
connector.}

\item{VpcConfiguration}{Configuration information for an Amazon Virtual Private Cloud to connect
to your data source. For more information, see \href{https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html}{Configuring a VPC}.}

\item{Description}{A new description for the data source connector.}

\item{Schedule}{The sync schedule you want to update for the data source connector.}

\item{RoleArn}{The Amazon Resource Name (ARN) of an IAM role with permission to access
the data source and required resources. For more information, see \href{https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html}{IAM roles for Amazon Kendra}.}

\item{LanguageCode}{The code for a language you want to update for the data source
connector. This allows you to support a language for all documents when
updating the data source. English is supported by default. For more
information on supported languages, including their codes, see \href{https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html}{Adding documents in languages other than English}.}

\item{CustomDocumentEnrichmentConfiguration}{Configuration information you want to update for altering document
metadata and content during the document ingestion process.

For more information on how to create, modify and delete document
metadata, or make other content alterations when you ingest documents
into Amazon Kendra, see \href{https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html}{Customizing document metadata during the ingestion process}.}
}
\description{
Updates an Amazon Kendra data source connector.

See \url{https://www.paws-r-sdk.com/docs/kendra_update_data_source/} for full documentation.
}
\keyword{internal}
